<?php

// --- Configuration ---
define('BOT_TOKEN', '8183230352:AAHUy7RO5bhbCA30PYzN28KJKyp89LatfKc'); // Corrected token as per your webhook info
define('API_URL', 'https://api.telegram.org/bot' . BOT_TOKEN . '/');
define('FF_INFO_API', 'https://community-ffbd.onrender.com/info?uid=');
define('DRESSUP_API', 'https://genprofile.vercel.app/generate?uid=');
define('BANNER_AVATAR_API', 'https://ff-banner-image.vercel.app/banner-image?uid=%s&region=%s');
define('ADMIN_USERNAME', 'Samiul1only');
define('ALLOWED_GROUPS_FILE', 'allowed_groups.json');
define('LOG_FILE', 'bot_log.txt'); // For debugging

// --- Timezone Mapping (Best Effort) ---
// This maps Free Fire region codes to common IANA timezones.
// You might need to expand or adjust this based on specific Free Fire regions.
$timezone_map = [
    'SG' => 'Asia/Singapore',
    'US' => 'America/New_York', // Using Eastern Time as a default for US
    'EU' => 'Europe/Berlin',    // Using Central European Time as a default for EU
    'BR' => 'America/Sao_Paulo',
    'ID' => 'Asia/Jakarta',
    'TH' => 'Asia/Bangkok',
    'IN' => 'Asia/Kolkata',
    'PK' => 'Asia/Karachi',
    'BD' => 'Asia/Dhaka',
    'PH' => 'Asia/Manila',
    'VN' => 'Asia/Ho_Chi_Minh',
    'RU' => 'Europe/Moscow',
    'TR' => 'Europe/Istanbul',
    'SA' => 'Asia/Riyadh',
    'MENA' => 'Asia/Dubai', // Using Dubai for MENA (Middle East & North Africa)
    'LA' => 'America/Mexico_City', // Using Mexico City for Latin America
    'JP' => 'Asia/Tokyo',
    'KR' => 'Asia/Seoul',
    // Add more mappings as needed for other FF regions
    // Default fallback if region not found
    'DEFAULT' => 'UTC'
];

// Set a default timezone for the script, to avoid warnings if none is set by the system
date_default_timezone_set('Asia/Singapore'); 

// --- Helper Functions ---

function log_message($message) {
    file_put_contents(LOG_FILE, date('[Y-m-d H:i:s]') . " " . $message . PHP_EOL, FILE_APPEND);
}

function sendTelegramApiRequest($method, $params = []) {
    $url = API_URL . $method;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        log_message("cURL error: " . curl_error($ch));
    }
    curl_close($ch);
    return json_decode($response, true);
}

function sendMessage($chat_id, $text, $parse_mode = 'HTML', $reply_markup = null, $reply_to_message_id = null) {
    $params = ['chat_id' => $chat_id, 'text' => $text, 'parse_mode' => $parse_mode];
    if ($reply_markup) {
        $params['reply_markup'] = $reply_markup;
    }
    if ($reply_to_message_id) {
        $params['reply_to_message_id'] = $reply_to_message_id;
    }
    return sendTelegramApiRequest('sendMessage', $params);
}

function editMessageText($chat_id, $message_id, $text, $parse_mode = 'HTML', $reply_markup = null) {
    $params = ['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => $text, 'parse_mode' => $parse_mode];
    if ($reply_markup) {
        $params['reply_markup'] = $reply_markup;
    }
    return sendTelegramApiRequest('editMessageText', $params);
}

function sendPhoto($chat_id, $photo_url, $caption = null, $parse_mode = 'HTML', $reply_to_message_id = null) {
    $params = ['chat_id' => $chat_id, 'photo' => $photo_url, 'parse_mode' => $parse_mode];
    if ($caption) {
        $params['caption'] = $caption;
    }
    if ($reply_to_message_id) {
        $params['reply_to_message_id'] = $reply_to_message_id;
    }
    return sendTelegramApiRequest('sendPhoto', $params);
}

function leaveChat($chat_id) {
    return sendTelegramApiRequest('leaveChat', ['chat_id' => $chat_id]);
}

function downloadImage($url, $filepath) {
    $ch = curl_init(); // Initialize cURL without URL here
    curl_setopt($ch, CURLOPT_URL, $url); // Set URL here
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // Follow redirects
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Temporarily disable SSL verification for testing if needed
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false); // Temporarily disable SSL verification for testing if needed
    $image_data = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($image_data === false || $http_code != 200) {
        log_message("Failed to download image from $url. HTTP code: $http_code");
        return false;
    }

    if (file_put_contents($filepath, $image_data) === false) {
        log_message("Failed to save image to $filepath");
        return false;
    }
    return true;
}

function getAllowedGroups() {
    if (!file_exists(ALLOWED_GROUPS_FILE)) {
        file_put_contents(ALLOWED_GROUPS_FILE, json_encode([]));
        return [];
    }
    return json_decode(file_get_contents(ALLOWED_GROUPS_FILE), true);
}

function saveAllowedGroups($groups) {
    file_put_contents(ALLOWED_GROUPS_FILE, json_encode($groups, JSON_PRETTY_PRINT));
}

// --- Main Bot Logic ---

$update = json_decode(file_get_contents('php://input'), true);

if (!$update) {
    log_message("Received invalid update: " . file_get_contents('php://input'));
    die('Invalid update');
}

$message = $update['message'] ?? null;
if (!$message) {
    log_message("No message found in update: " . json_encode($update));
    die('No message found');
}

$chat_id = $message['chat']['id'];
$chat_type = $message['chat']['type'];
$text = $message['text'] ?? '';
$from_id = $message['from']['id'];
$from_username = $message['from']['username'] ?? '';
$original_message_id = $message['message_id']; // Capture the ID of the user's command message
$is_admin = (strtolower($from_username) === strtolower(ADMIN_USERNAME)); // Case-insensitive check

log_message("Received message: " . json_encode($message));

// Group usage tracking for unauthorized groups
if ($chat_type === 'group' || $chat_type === 'supergroup') {
    $allowed_groups = getAllowedGroups();
    if (!in_array($chat_id, $allowed_groups) && !$is_admin) {
        $group_usage_file = 'group_usage_' . $chat_id . '.txt';
        $usage_count = 0;
        if (file_exists($group_usage_file)) {
            $usage_count = (int)file_get_contents($group_usage_file);
        }
        $usage_count++;
        file_put_contents($group_usage_file, $usage_count);

        if ($usage_count >= 3) {
            sendMessage($chat_id, "This bot is not allowed in this group. Leaving now.", 'HTML', null, $original_message_id);
            leaveChat($chat_id);
            unlink($group_usage_file);
            die();
        } else {
             sendMessage($chat_id, "This bot is currently not allowed in this group. If you wish to use it, an admin needs to add this group. Otherwise, I will leave after " . (3 - $usage_count) . " more uses. Contact @" . ADMIN_USERNAME . " for assistance.", 'HTML', null, $original_message_id);
        }
    }
}


// --- Command Handling ---

if (strpos($text, '/') === 0) { // It's a command
    $command = explode(' ', $text)[0];
    $command_args = array_slice(explode(' ', $text), 1);

    switch ($command) {
        case '/start':
            sendMessage($chat_id, "Hello! I'm your Free Fire profile bot. Use /help to see what I can do.", 'HTML', null, $original_message_id);
            break;

        case '/help':
            $help_message = "✨ - Profileinfo FFBD - ✨\n\n"
                          . "🔎 What Can I Do?\n\n"
                          . "Every successful command will Fetch your Free Fire profile Info You can see your all profile information here.\n"
                          . "🟢 How to Use?\n\n"
                          . "Use /info to fetch profile info.\n"
                          . "Example: <code>/info 12345678 SG</code>\n"
                          . "📛 Need More Help?\n"
                          . "For more information, suggestions, or access issues, feel free to contact @" . ADMIN_USERNAME . ".\n"
                          . "👤 Alright ☠️<a href=\"https://t.me/deathhaxor\">Death Haxor</a>☠️, Have a great time with this bot.\n\n"
                          . "🖥️ Bot Developed By: @" . ADMIN_USERNAME . " 🗿";
            sendMessage($chat_id, $help_message, 'HTML', null, $original_message_id);
            break;

        case '/addgr':
            if (!$is_admin) {
                sendMessage($chat_id, "You are not authorized to use this command.", 'HTML', null, $original_message_id);
                break;
            }
            if ($chat_type !== 'group' && $chat_type !== 'supergroup') {
                sendMessage($chat_id, "This command can only be used in a group to add it to the allowed list.", 'HTML', null, $original_message_id);
                break;
            }

            $allowed_groups = getAllowedGroups();
            if (!in_array($chat_id, $allowed_groups)) {
                $allowed_groups[] = $chat_id;
                saveAllowedGroups($allowed_groups);
                // Clean up usage file if it existed
                $group_usage_file = 'group_usage_' . $chat_id . '.txt';
                if (file_exists($group_usage_file)) {
                    unlink($group_usage_file);
                }
                sendMessage($chat_id, "This group has been added to the allowed list.", 'HTML', null, $original_message_id);
            } else {
                sendMessage($chat_id, "This group is already in the allowed list.", 'HTML', null, $original_message_id);
            }
            break;

        case '/rm':
            if (!$is_admin) {
                sendMessage($chat_id, "You are not authorized to use this command.", 'HTML', null, $original_message_id);
                break;
            }
            if ($chat_type !== 'group' && $chat_type !== 'supergroup') {
                sendMessage($chat_id, "This command can only be used in a group to remove it from the allowed list and make the bot leave.", 'HTML', null, $original_message_id);
                break;
            }

            $allowed_groups = getAllowedGroups();
            $index = array_search($chat_id, $allowed_groups);
            if ($index !== false) {
                array_splice($allowed_groups, $index, 1);
                saveAllowedGroups($allowed_groups);
                // Clean up usage file
                $group_usage_file = 'group_usage_' . $chat_id . '.txt';
                if (file_exists($group_usage_file)) {
                    unlink($group_usage_file);
                }
                sendMessage($chat_id, "This group has been removed from the allowed list. I am now leaving this group.", 'HTML', null, $original_message_id);
                leaveChat($chat_id);
            } else {
                sendMessage($chat_id, "This group is not in the allowed list.", 'HTML', null, $original_message_id);
            }
            break;

        case '/info':
            if ($chat_type === 'private') {
                sendMessage($chat_id, "The /info command can only be used in groups.", 'HTML', null, $original_message_id);
                break;
            }

            $allowed_groups = getAllowedGroups();
            if (!in_array($chat_id, $allowed_groups)) {
                sendMessage($chat_id, "This group is not authorized to use the /info command. Please contact @" . ADMIN_USERNAME . " to allow this group.", 'HTML', null, $original_message_id);
                break;
            }

            if (count($command_args) < 2) {
                sendMessage($chat_id, "Usage: <code>/info &lt;UID&gt; &lt;Region&gt;</code>\nExample: <code>/info 12345678 SG</code>", 'HTML', null, $original_message_id);
                break;
            }

            $uid = $command_args[0];
            $region = strtoupper($command_args[1]); // Ensure region is uppercase

            // Determine the timezone based on the provided region
            global $timezone_map; // Ensure access to the global map
            $target_timezone = $timezone_map[$region] ?? $timezone_map['DEFAULT'];
            date_default_timezone_set($target_timezone); // Set the timezone for this script execution

            // Send initial "Fetching data..." message and get its message_id
            $initial_message_response = sendMessage($chat_id, "Fetching data for UID: <code>$uid</code>, Region: <code>$region</code> (Timezone: <code>" . $target_timezone . "</code>)...", 'HTML', null, $original_message_id);
            $bot_message_id_to_edit = null;
            if (isset($initial_message_response['ok']) && $initial_message_response['ok'] && isset($initial_message_response['result']['message_id'])) {
                $bot_message_id_to_edit = $initial_message_response['result']['message_id'];
            } else {
                log_message("Failed to send initial message or get message_id: " . json_encode($initial_message_response));
            }


            // Fetch basic info
            $info_url = FF_INFO_API . $uid;
            $ff_data_json = @file_get_contents($info_url); // Use @ to suppress warnings for network errors
            $ff_data = json_decode($ff_data_json, true);

            if (!$ff_data || !isset($ff_data['basicInfo'])) {
                $error_message = "Could not retrieve Free Fire info for UID: <code>$uid</code>. Please check the UID or try again later.";
                if ($bot_message_id_to_edit) {
                    editMessageText($chat_id, $bot_message_id_to_edit, $error_message, 'HTML');
                } else {
                    sendMessage($chat_id, $error_message, 'HTML', null, $original_message_id);
                }
                log_message("Failed to fetch FF_INFO from " . $info_url . " - Response: " . $ff_data_json);
                // Reset timezone
                date_default_timezone_set('Asia/Singapore'); 
                break;
            }

            $basicInfo = $ff_data['basicInfo'];
            $profileInfo = $ff_data['profileInfo'] ?? [];
            $clanBasicInfo = $ff_data['clanBasicInfo'] ?? [];
            $captainBasicInfo = $ff_data['captainBasicInfo'] ?? [];
            $petInfo = $ff_data['petInfo'] ?? [];
            $socialInfo = $ff_data['socialInfo'] ?? [];
            $creditScoreInfo = $ff_data['creditScoreInfo'] ?? [];

            // --- Download and Save Images ---
            $dressup_image_url = DRESSUP_API . $uid;
            $dressup_filename = 'xdressup/' . $uid . '_dressup.png';
            $dressup_local_url = 'https://ffapi.courcenet.my.id/bots/xdressup/' . $uid . '_dressup.png';

            $banner_avatar_image_url = sprintf(BANNER_AVATAR_API, $uid, $region);
            $banner_avatar_filename = 'banandavt/' . $uid . '_' . strtolower($region) . '_banner_avatar.png';
            $banner_avatar_local_url = 'https://ffapi.courcenet.my.id/bots/banandavt/' . $uid . '_' . strtolower($region) . '_banner_avatar.png';

            // Create directories if they don't exist
            if (!is_dir('xdressup')) {
                mkdir('xdressup', 0777, true);
            }
            if (!is_dir('banandavt')) {
                mkdir('banandavt', 0777, true);
            }

            $dressup_downloaded = downloadImage($dressup_image_url, $dressup_filename);
            $banner_avatar_downloaded = downloadImage($banner_avatar_image_url, $banner_avatar_filename);

            // Format timestamps according to the determined timezone
            $createdAtFormatted = (isset($basicInfo['createAt']) && is_numeric($basicInfo['createAt'])) ? date('Y-m-d H:i:s T', $basicInfo['createAt']) : 'N/A';
            $lastLoginAtFormatted = (isset($basicInfo['lastLoginAt']) && is_numeric($basicInfo['lastLoginAt'])) ? date('Y-m-d H:i:s T', $basicInfo['lastLoginAt']) : 'N/A';


            // Construct the final response message
            $response_text = "<b>ACCOUNT INFO:</b>\n"
                           . "┌ 👤 ACCOUNT BASIC INFO\n"
                           . "├─ Name: " . htmlspecialchars($basicInfo['nickname'] ?? 'N/A') . "\n"
                           . "├─ UID: " . htmlspecialchars($basicInfo['accountId'] ?? 'N/A') . "\n"
                           . "├─ Level: " . htmlspecialchars($basicInfo['level'] ?? 'N/A') . " (Exp: " . htmlspecialchars($basicInfo['exp'] ?? 'N/A') . ")\n"
                           . "├─ Region: " . htmlspecialchars($basicInfo['region'] ?? 'N/A') . "\n"
                           . "├─ Likes: " . htmlspecialchars($basicInfo['liked'] ?? 'N/A') . "\n"
                           . "├─ Honor Score: " . htmlspecialchars($creditScoreInfo['creditScore'] ?? 'N/A') . "\n"
                           . "├─ Celebrity Status: " . ($basicInfo['hasElitePass'] ?? false ? 'True' : 'False') . "\n"
                           . "├─ Evo Access Badge: " . htmlspecialchars($basicInfo['badgeId'] ?? 'N/A') . "\n"
                           . "└─ Signature: " . htmlspecialchars($socialInfo['signature'] ?? 'N/A') . "\n\n"

                           . "<b>┌ 🎮 ACCOUNT ACTIVITY</b>\n"
                           . "├─ Most Recent OB: " . htmlspecialchars($basicInfo['releaseVersion'] ?? 'N/A') . "\n"
                           . "├─ Fire Pass: " . ($basicInfo['hasElitePass'] ?? false ? 'Premium' : 'N/A') . "\n"
                           . "├─ Current BP Badges: " . htmlspecialchars($basicInfo['badgeCnt'] ?? 'N/A') . "\n"
                           . "├─ Account Type: " . htmlspecialchars($basicInfo['accountType'] ?? 'N/A') . "\n"
                           . "├─ BR Rank: " . htmlspecialchars($basicInfo['rank'] ?? 'N/A') . " (" . htmlspecialchars($basicInfo['rankingPoints'] ?? 'N/A') . ")\n"
                           . "├─ CS Points: " . htmlspecialchars($basicInfo['csRankingPoints'] ?? 'N/A') . "\n"
                           . "├─ Created At: " . $createdAtFormatted . "\n"
                           . "└─ Last Login: " . $lastLoginAtFormatted . "\n\n"

                           . "<b>┌ 👕 ACCOUNT OVERVIEW</b>\n"
                           . "├─ Avatar & Banner: " . ($banner_avatar_downloaded ? $banner_avatar_local_url : 'Failed to retrieve') . "\n"
                           . "├─ Dress up: " . ($dressup_downloaded ? $dressup_local_url : 'Failed to retrieve') . "\n"
                           . "├─ Equipped Gun ID: " . (!empty($basicInfo['weaponSkinShows']) ? htmlspecialchars($basicInfo['weaponSkinShows'][0]) : 'N/A') . "\n"
                           . "├─ Equipped Anime ID: N/A\n"
                           . "└─ Transform Animation ID: N/A\n\n"

                           . "<b>┌ 🐾 PET DETAILS</b>\n"
                           . "├─ Equipped?: " . (isset($petInfo['isSelected']) ? ($petInfo['isSelected'] ? 'Yes' : 'No') : 'N/A') . "\n"
                           . "├─ Pet Name: " . htmlspecialchars($petInfo['name'] ?? 'N/A') . "\n"
                           . "├─ Pet Type: " . htmlspecialchars($petInfo['id'] ?? 'N/A') . "\n"
                           . "├─ Pet Exp: " . htmlspecialchars($petInfo['exp'] ?? 'N/A') . "\n"
                           . "├─ IsSelected: " . (isset($petInfo['isSelected']) ? ($petInfo['isSelected'] ? 'True' : 'False') : 'N/A') . "\n"
                           . "└─ Pet Level: " . htmlspecialchars($petInfo['level'] ?? 'N/A') . "\n\n"

                           . "<b>┌ 🛡️ GUILD INFO</b>\n"
                           . "├─ Guild Name: " . htmlspecialchars($clanBasicInfo['clanName'] ?? 'N/A') . "\n"
                           . "├─ Guild ID: " . htmlspecialchars($clanBasicInfo['clanId'] ?? 'N/A') . "\n"
                           . "├─ Guild Level: " . htmlspecialchars($clanBasicInfo['clanLevel'] ?? 'N/A') . "\n"
                           . "├─ Guild Capacity: " . htmlspecialchars($clanBasicInfo['capacity'] ?? 'N/A') . "\n"
                           . "├─ Live Members: " . htmlspecialchars($clanBasicInfo['memberNum'] ?? 'N/A') . "\n"
                           . "└─ Leader Info:\n"
                     
                           . "  ├─ Leader Name: " . htmlspecialchars($captainBasicInfo['nickname'] ?? 'N/A') . "\n"
                           . "  ├─ Leader UID: " . htmlspecialchars($captainBasicInfo['accountId'] ?? 'N/A') . "\n"
                           . "  ├─ Leader Level: " . htmlspecialchars($captainBasicInfo['level'] ?? 'N/A') . " (Exp: " . htmlspecialchars($captainBasicInfo['exp'] ?? 'N/A') . ")\n"
                           . "  ├─ Leader Title: " . htmlspecialchars($captainBasicInfo['title'] ?? 'N/A') . "\n"
                           . "  ├─ Leader Current BP Badges: " . htmlspecialchars($captainBasicInfo['badgeCnt'] ?? 'N/A') . "\n"
                           . "  ├─ Leader BR Points: " . htmlspecialchars($captainBasicInfo['rank'] ?? 'N/A') . "\n"
                           . "  └─ Leader CS Points: " . htmlspecialchars($captainBasicInfo['csRankingPoints'] ?? 'N/A') . "\n\n"

                           . "<b>┌ 🛠️ EXTRA INFO</b>\n"
                           . "├─ Release Version: " . htmlspecialchars($basicInfo['releaseVersion'] ?? 'N/A') . "\n"
                           . "├─ Show BR Rank: " . ($basicInfo['showBrRank'] ?? false ? 'True' : 'False') . "\n"
                           . "├─ Show CS Rank: " . ($basicInfo['showCsRank'] ?? false ? 'True' : 'False') . "\n"
                           . "└─ External Icon Info:\n"
                           . "  ├─ Status: " . htmlspecialchars($basicInfo['externalIconInfo']['status'] ?? 'N/A') . "\n"
                           . "  └─ Show Type: " . htmlspecialchars($basicInfo['externalIconInfo']['showType'] ?? 'N/A');

            // Edit the initial message with the full info
            if ($bot_message_id_to_edit) {
                editMessageText($chat_id, $bot_message_id_to_edit, $response_text, 'HTML');
            } else {
                // Fallback: If for some reason we couldn't get the message_id to edit, send as a new reply
                sendMessage($chat_id, $response_text, 'HTML', null, $original_message_id);
            }

            // Reset timezone
            date_default_timezone_set('Asia/Singapore'); 
            break;

        default:
            // Ignore unknown commands
            break;
    }
}
?>
